// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedure for adding individual keys to a key ring.
//....................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#include "sha2.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	TCHAR				szDestination[MAX_PATH];
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	LPBYTE				lpKeyBuffer3;
extern	LPCD_STRUCT			lpPublicKeyCentralDir;
extern	LPCD_STRUCT			lpSecretKeyCentralDir;
extern	LPCD_STRUCT			lpScratchCentralDir;
extern	LPCD_STRUCT			lpScratchCentralDir1;
extern	DWORD				dwSecretIds;
extern	DWORD				dwPublicIds;
extern	BYTE				KeySID;
extern	LPBYTE				lpKeyBufferDup1;
extern	LPBYTE				lpKeyBufferDup2;
extern	LPBYTE				lpRingFile2;
extern	LPBYTE				lpIndexFile1;
extern	LPBYTE				lpIndexFile2;
extern	HANDLE				hIdxHandle1;
extern	HANDLE				hIdxHandle2;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	TCHAR				szYes;
extern	DWORD				dwIdxOffset2;
extern	DWORD				dwIdxOffset1;
extern	DWORD				dwEditFunction;
extern	DWORD				MarkType;
extern	BOOL				bSingleSelectionOnly;
extern	int					iItemCount;
extern	int					iItemsSelected;
extern	int					iMaxItems;
extern	CD_STRUCT			CDLine1;
extern	BYTE				TempUserId[256];
extern	DWORD				dwN_Bytes;
extern	DWORD				dwN_Bits;
extern	DWORD				dwE_Bytes;
extern	HICON				hIcon2;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bCancelOperation;
extern	SHFILEINFO			shfi1;
extern	TCHAR				szBeginTsc[];
extern	TCHAR				szBeginPgp[];
extern	TCHAR				szEndTsc[];
extern	TCHAR				szEndPgp[];
extern	SKEY_HDR			skh;
extern	BYTE				ShaDigest[SHA_DIGEST_SIZE];
extern	BYTE				Sha512Digest[SHA512_DIGEST_SIZE];
extern	BYTE				D_Temp[MAX_MOD_SLOP];
extern	BYTE				Prime_P[MAX_PRIME_SLOP];
extern	BYTE				Prime_Q[MAX_PRIME_SLOP];
extern	BYTE				U_Temp[MAX_MOD_SLOP];
extern	DWORD				dwCDLength;
extern	DWORD				dwCountBytes;
extern	DWORD				dwCountBits;
extern	LPTSTR				lpszClipboard;
extern	BOOL				bExport;
extern	BOOL				bUseMd5;
extern	BYTE				Md5Digest[MD5_DIGEST_SIZE];
extern	DWORD				dwErrorCodeComm;
extern	LPBYTE				lpSearchEDI;
extern	LPBYTE				lpLineFeed;
extern	BOOL				bWeHaveSha;
extern	DWORD				dwSigBits;
extern	BYTE				Temp1[MAX_MOD_SLOP*2];
extern	BYTE				Temp2[MAX_MOD_SLOP*2];
extern	LPBYTE				lpRingFile1;
extern	BYTE				Modulus_N[MAX_MOD_SLOP];
extern	BYTE				E_Temp[MAX_MOD_SLOP];
extern	TCHAR				Line1[90];
extern	TCHAR				szKeyDateTime[];
extern	SYSTEMTIME			stCreated;
extern	TCHAR				TimeSep;
extern	TCHAR				szTime[];
extern	BOOL				bWin2000OrGreater;
extern	BOOL				bProgramRegistered;

// Variables for signing a file.
//..............................
BOOL			bSendToFile;
BOOL			bTextOutput;
BOOL			bSigInClipboard;
BOOL			bSigsTheSame;
DWORD			dwDigestType;
TCHAR			szSigExt[] = ".tsig";
TCHAR			szCheckFile[MAX_PATH];
LARGE_INTEGER	liMySigTimestamp;

HFONT			hDlgFont;
LOGFONT			lFont;
HFONT			hDlgFont2;
LOGFONT			lFont2;
TCHAR			LongLine1[128];
TCHAR			LongLine2[128];

TCHAR			SigHeader[] = "-----BEGIN TSC SIGNATURE-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Private or Commercial Use - www.topsecretcrypto.com\r\n\r\n";
TCHAR			SigHeaderP[] = "-----BEGIN TSC SIGNATURE-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Personal Private Use Only - www.topsecretcrypto.com\r\n\r\n";
TCHAR			SigFooter[] = "-----END TSC SIGNATURE-----\r\n";

// Check a file's signatures. It may be in a file or the clipboard.
// If from the command line the sig file is in szDestination.
//.................................................................
VOID CheckFilesSig(LPBYTE lpSigFile)
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liPublicKeyExpire;
	DWORD			dwOldHelpTopic;
	OPENFILENAME	ofn;
	int				i;
	int				iResult;
	BOOL			bResult;
	DWORD			dwResult;
	BOOL			bError;
	UINT			uFormat = 0;
	LPBYTE			lpMyClipboard = 0;
	LPBYTE			lpSigBuffer = 0;
	LPBYTE			lpDestination = 0;
	DWORD			dwDestSize = 0;
	LPBYTE			lpSigBufferDup;
	HGLOBAL			hGlobal;
	LPBYTE			lpClipboard;
	DWORD			dwLength = 0;
	DWORD			dwSearchLength;
	DWORD			dwTemp = 0;
	DWORD			dwSigSize;
	DWORD			dwCrc24;
	DWORD			dwCrc24Dup;
	DWORD			dwKeyLength;
	HANDLE			hSigFile = 0;
	DWORD			dwBytesWritten;
	DWORD			dwBytesRead;
	TCHAR			szTempPath[MAX_PATH];
	LPBYTE			lpMd5AppendPtr;
	LPBYTE			lpMd5_2_Ptr;
	DWORD			dwMd5AppendLength;
	DWORD			dwCtb_Byte;
	BYTE			TempByte;
	BYTE			CtbByte;
	LPBYTE			lpTempEDI;
	DWORD			dwRsaIntegerBits;
	DWORD			dwRsaIntegerBytes;
	DWORD			dwIdLength;
	HANDLE			hCheckFile = 0;
	WIN32_FIND_DATA	wfd;
	HANDLE			hSearch;
	BOOL			bAskForFile = TRUE;
	BYTE			Md5ForFile[MD5_DIGEST_SIZE];
	BYTE			ShaForFile[SHA_DIGEST_SIZE];
	BYTE			Sha512ForFile[SHA512_DIGEST_SIZE];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_CHECK_FILE_SIG);
	bWeHaveSha = FALSE;

	// Clear all the variables we will be using.
	//..........................................
	ClearAllVariables();
	ClearMathVariables();

	// Setup the key rings.
	//.....................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
	SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_TWO);

		// Allocate memory for the buffers we will use.
	//.............................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);

	if (!lpKeyBuffer1 || !lpKeyBuffer2 || !lpKeyBuffer3)
	{
		goto CheckEnd;
	}
	// If no sig file is passed from the command line we have to get it.
	//..................................................................
	if (!lpSigFile)
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		InitializeOFN(&ofn,SAVE_SOURCE);

		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szDestination;
		ofn.nMaxFile = sizeof(szDestination);
		ofn.hwndOwner = hMainWindow;
		ofn.hInstance = hInst;
		ofn.lpstrFilter = TEXT("Tscg Signature Files [.tsig]\0*.tsig\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select a Signature File to Verify and Check");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY |
					 OFN_ENABLETEMPLATE);
		if (bWin2000OrGreater)
		{
			ofn.lpTemplateName = TEXT("CHECKFILESIGNATURENEW");
		}
		else
		{
			ofn.lpTemplateName = TEXT("CHECKFILESIGNATURE");
		}
		ofn.lpfnHook = MyCheckOFNHookProc;
		ofn.lpstrDefExt = NULL;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;
		ZeroMemory(&szDestination,MAX_PATH);

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			if (dwErrorCodeComm || (dwErrorCodeComm == 0 && !bSigInClipboard))
			{
				goto CheckEnd;
			}
		}
		SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,TRUE);
	}
	// We either have a file name in szDestination or the signature is in the clipboard.
	// Save the clipboard data to a temporary file.
	//..................................................................................
	if (bSigInClipboard)
	{	
		bResult = OpenClipboard(hMainWindow);
		if (!bResult)
		{
			ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
			goto CheckEnd;
		}
		while(TRUE)
		{
			uFormat = EnumClipboardFormats(uFormat);
			if (uFormat == 0)
			{
				if (GetLastError() != NO_ERROR)
				{
					ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
					goto CheckEnd;
				}
				else
				{
					SetLastError(IDS_NOTEXTFORMAT);
					ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
					goto CheckEnd;
				}
			}
			if (uFormat == CF_TEXT)
			{
				break;
			}
		}
		// We have a text format to get, so do it.
		//........................................
		hGlobal = GetClipboardData(uFormat);
		if (!hGlobal)
		{
			ErrorProcedure(lpszClipboard,IDS_GETCLIPBOARD,MB_OK);
			goto CheckEnd;
		}
		lpClipboard = GlobalLock(hGlobal);
		if (!lpClipboard)
		{
			ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
			goto CheckEnd;
		}
		// Get the length of the clipboard so we can allocate our own memory block.
		//.........................................................................
		dwLength = (lstrlen((LPCTSTR)lpClipboard) + 1);

		lpMyClipboard = AllocateMemory(dwLength);
		if (!lpMyClipboard)
		{
			ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
			goto CheckEnd;
		}
		// Copy the clipboard to our memory block.
		//........................................
		CopyMemory(lpMyClipboard,lpClipboard,dwLength);

		GlobalUnlock(hGlobal);

		// Close the clipboard.
		//.....................
		bResult = CloseClipboard();
		if (!bResult)
		{
			ErrorProcedure(lpszClipboard,IDS_CLOSECLIPBOARD,MB_OK);
		}
		// Create a temporary file and save the contents of the clipboard to disk.
		//........................................................................
		ZeroMemory(&szDestination,MAX_PATH);
		GetTempPath(MAX_PATH,(LPTSTR)&szTempPath);
		GetTempFileName((LPTSTR)&szTempPath,TEXT("idx"),0,(LPTSTR)&szDestination);
		hSigFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_WRITE,0,NULL,
								 CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hSigFile)
		{
			goto CheckEnd;
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hSigFile,lpMyClipboard,dwLength,
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto CheckEnd;
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hSigFile);
		if (!bResult)
		{
			goto CheckEnd;
		}
		hSigFile = 0;
	}
	// We now have a file with the signature in it. Check out the file to make sure.
	//..............................................................................
	hSigFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,OPEN_EXISTING,
							FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hSigFile)
	{
		goto CheckEnd;
	}
	li.QuadPart = GetMyFileSize((LPTSTR)&szDestination,hSigFile);
	if (li.QuadPart == -1)
	{
		goto CheckEnd;
	}
	// Check to make sure sig file is not too large.
	//..............................................
	if (li.QuadPart > (6 * 1024))
	{
		SetLastError(IDS_SIGFILEINVALID);
		ErrorProcedure((LPTSTR)&szDestination,IDS_GETFILESIZE,MB_OK);
		goto CheckEnd;
	}
	dwSigSize = li.LowPart;
	lpSigBuffer = AllocateMemory(dwSigSize);
	if (!lpSigBuffer)
	{
		goto CheckEnd;
	}
	bResult = ReadMyFile((LPTSTR)&szDestination,hSigFile,lpSigBuffer,dwSigSize,
						 &dwBytesRead,NULL);
	if (!bResult)
	{
		goto CheckEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szDestination,hSigFile);
	if (!bResult)
	{
		goto CheckEnd;
	}
	hSigFile = 0;

	// Check the first character of the file for a signature CTB byte.
	//................................................................
	__asm
	{
		mov		edi,lpSigBuffer
		mov		al,byte ptr [edi]
		and		al,CTB_MASK
		mov		TempByte,al
	}
	if (TempByte != CTB_SKE_PACKET)
	{
		// First check out the buffer for a radix-64 text signature.
		//..........................................................
		dwSearchLength = dwSigSize;

		// Scan for at least 4 line feed characters in the public message.
		//................................................................
		__asm
		{
			mov		ecx,dwSearchLength
			mov		esi,lpSigBuffer
		L1:	lodsb
			cmp		al,0x00
			je		L3
			cmp		al,0x0a
			jne		L2
			inc		dwTemp
		L2:	dec		ecx
			jnz		L1
		}
		L3:

		if (dwTemp < 4)
		{
			SetLastError(IDS_SIGFILEINVALID);
			ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		// Check for the trailer first to see if we have a signature block.
		//.................................................................
		bResult = SearchFor((LPBYTE)&SigFooter,8,(LPBYTE)lpSigBuffer,dwSearchLength);
		if (!bResult)
		{
			SetLastError(IDS_SIGFILEINVALID);
			ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		// Search for the last part of the trailing header.
		//.................................................
		lpSigBufferDup = lpSearchEDI;
		dwSearchLength = (dwSigSize + lpSigBuffer - lpSigBufferDup);

		bResult = SearchFor((LPBYTE)&SigFooter[13],14,(LPBYTE)lpSigBufferDup,dwSearchLength);
		if (!bResult)
		{
			SetLastError(IDS_SIGFILEINVALID);
			ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		dwSearchLength = dwSigSize;

		// Check the header to  see if we have a valid signature block.
		//.............................................................
		bResult = SearchFor((LPBYTE)&SigHeader,10,(LPBYTE)lpSigBuffer,dwSearchLength);
		if (!bResult)
		{
			SetLastError(IDS_SIGFILEINVALID);
			ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		// Look for the public key block.
		//...............................
		lpSigBufferDup = lpSearchEDI;
		__asm
		{
			add		lpSigBufferDup,15
		}
		bResult = SearchFor((LPBYTE)&SigHeader[15],14,lpSigBufferDup,30);
		if (!bResult)
		{
			SetLastError(IDS_SIGFILEINVALID);
			ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		// Now we have to get past the version line and find the start of the key.
		// Search for line feeds with a first character of 'i' following.
		//........................................................................
		dwSearchLength = (dwSigSize + lpSigBuffer - lpSigBufferDup);

		i = 5;
		while(i > 0)
		{
			bResult = SearchFor(lpLineFeed,1,lpSigBufferDup,dwSearchLength);
			if (!bResult)
			{
				SetLastError(IDS_SIGFILEINVALID);
				ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
				goto CheckEnd;
			}
			lpSigBufferDup = lpSearchEDI;
			lpSigBufferDup++;
			if (*lpSigBufferDup == 'i')
			{
				break;
			}
			dwSearchLength = (dwSigSize + lpSigBuffer - lpSigBufferDup);
			i--;
		}
		if (*lpSigBufferDup != 'i')
		{
			SetLastError(IDS_SIGFILEINVALID);
			ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		// lpSigBufferDup points to the start of the signature block.
		// Decode the block to get our signature and crc24 value.
		//...........................................................
		lpDestination = AllocateMemory(dwSigSize + 4096);
		if (!lpDestination)
		{
			goto CheckEnd;
		}
		dwDestSize = (dwSigSize + 4096);
		dwCrc24 = CRC24_INIT;
		lpSigBufferDup = DearmorBuffer(lpSigBufferDup,lpDestination,&dwKeyLength);
		if (lpSigBufferDup == 0)
		{
			SetLastError(IDS_DEARMORBUFFERERROR);
			ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
			goto CheckEnd;
		}
		// We are finished with the conversion of the key.
		// Calculate the crc24 value.
		//................................................
		dwCrc24 = Crc24Update(dwCrc24,lpDestination,dwKeyLength);

		// Backup the pointer 2 spaces so we can search for a \n.
		//.......................................................
		lpSigBufferDup--;
		lpSigBufferDup--;

		// Now retrieve the crc24 value from the clipboard buffer.
		// lpClipboard points to the = after the key and before
		// the crc24 value. Could be more than one.
		//........................................................
		bResult = SearchFor(lpLineFeed,1,lpSigBufferDup,10);
		if (!bResult)
		{
			SetLastError(IDS_NOVALIDCRC24);
			ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		lpSigBufferDup = lpSearchEDI;
		lpSigBufferDup++;
		if (*lpSigBufferDup != '=')
		{
			SetLastError(IDS_NOVALIDCRC24);
			ErrorProcedure((LPTSTR)&szDestination,IDS_SEARCHFOR,MB_OK);
			goto CheckEnd;
		}
		lpSigBufferDup++;

		dwCrc24Dup = GetCrc24(lpSigBufferDup);

		if (dwCrc24 != dwCrc24Dup)
		{
			SetLastError(IDS_CRC24NOMATCH);
			ErrorProcedure((LPTSTR)&szDestination,IDS_COMPARE,MB_OK);
			goto CheckEnd;
		}
		// Now put the signature in lpDestination into lpSigBuffer.
		//.........................................................
		if (lpSigBuffer)
		{
			ZeroMemory(lpSigBuffer,dwSigSize);
			DeallocateMemory(lpSigBuffer);
			lpSigBuffer = 0;
		}
		lpSigBuffer = AllocateMemory(dwKeyLength);
		if (!lpSigBuffer)
		{
			goto CheckEnd;
		}
		dwSigSize = dwKeyLength;
		CopyMemory(lpSigBuffer,lpDestination,dwKeyLength);

		ZeroMemory(lpDestination,dwDestSize);
		DeallocateMemory(lpDestination);
		lpDestination = 0;
	}
	// A binary key should now be in lpSigBuffer. Check it out.
	// We do not handle new version or version 4 sigs.
	//.........................................................
	lpSigBufferDup = lpSigBuffer;

	__asm
	{
		mov		edi,lpSigBuffer
		mov		al,byte ptr [edi]
		mov		cl,al
		mov		TempByte,al
		mov		dwCtb_Byte,ecx
		and		al,CTB_MASK
		mov		CtbByte,al
	}
	if (TempByte & 0x40)
	{
		SetLastError(IDS_DONOTSUPPORTNEWSIGFORMAT);
		ErrorProcedure((LPTSTR)&szDestination,IDS_CHECKSIGPROC,MB_OK);
		goto CheckEnd;
	}
	if (CtbByte != CTB_SKE_PACKET)
	{
		SetLastError(IDS_NOTVALIDSIGPKT);
		ErrorProcedure((LPTSTR)&szDestination,IDS_CHECKSIGPROC,MB_OK);
		goto CheckEnd;
	}
	// Point to length field.
	//.......................
	lpSigBufferDup++;

	// Get the length of the length field.
	//....................................
	__asm
	{
		mov		edx,1
		mov		ecx,dwCtb_Byte
		and		ecx,LENGTH_MASK
		shl		edx,cl
		add		lpSigBufferDup,edx
		mov		edi,lpSigBufferDup
		mov		al,byte ptr [edi+15]
		and		al,0x01
		mov		TempByte,al
	}
	// lpSigBufferDup points to version byte.
	//.......................................
	if (*lpSigBufferDup != VERSION_OLD && *lpSigBufferDup != VERSION_NEW)
	{
		if(*lpSigBufferDup == VERSION_4_KEY)
		{
			SetLastError(IDS_DONOTSUPPORTNEWSIGFORMAT);
		}
		else
		{
			SetLastError(IDS_UNKNOWNSIGVERSION);
		}
		ErrorProcedure((LPTSTR)&szDestination,IDS_CHECKSIGPROC,MB_OK);
		goto CheckEnd;
	}
	// Check out the rest of the key.
	//...............................
	if ((*(lpSigBufferDup+1) != SKE_APPEND_LGTH && *(lpSigBufferDup+1) != SKE_SHA_APPEND_LGTH) ||
		 *(lpSigBufferDup+2) != SIG_MSG_BINARY ||
		(*(lpSigBufferDup+16) != MD5_ALGORITHM && *(lpSigBufferDup+16) != SHA_ALGORITHM 
		 && *(lpSigBufferDup+16) != SHA512_ALGORITHM) || TempByte != RSA_ALGORITHM)
	{
		SetLastError(IDS_INVALIDSIGPACKET);
		ErrorProcedure((LPTSTR)&szDestination,IDS_CHECKSIGPROC,MB_OK);
		goto CheckEnd;
	}
	if (*(lpSigBufferDup+16) == MD5_ALGORITHM)
	{
		dwMd5AppendLength = SKE_APPEND_LGTH;
	}
	else
	{
		dwMd5AppendLength =	SKE_SHA_APPEND_LGTH;
	}
	liMySigTimestamp.QuadPart = 0;

	__asm
	{
		mov		edi,lpSigBufferDup
		add		edi,(VERSION_SIZE+1)
		mov		lpMd5AppendPtr,edi
		inc		edi
		mov		eax,dword ptr [edi]
		bswap	eax
		mov		liMySigTimestamp.LowPart,eax

		// Get the high order 7 bits of the timestamp.
		//............................................
		mov		eax,dword ptr [edi+12]
		and		eax,0x00ff
		shr		eax,1
		mov		liMySigTimestamp.HighPart,eax

		add		edi,TIMESTAMP_SIZE

		// Get the key id so we can find the public key.
		//..............................................
		mov		eax,dword ptr [edi]
		mov		edx,dword ptr [edi+4]
		mov		dword ptr KeySID,eax
		mov		dword ptr KeySID[4],edx
		add		edi,(KEY_ID_SIZE + (2 * ALGORITHM_SIZE))

		// Save the pointer to the 1st two bytes of the md5 or sha digest.
		//................................................................
		mov		lpMd5_2_Ptr,edi

		// Setup the rsa integer to decrypt.
		//..................................
		add		edi,2
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ah,al
		mov		dwRsaIntegerBits,eax
		mov		dwSigBits,eax
		mov		lpTempEDI,edi
	}
	// If the ske integer is too big we have to bail out.
	//...................................................
	if (dwRsaIntegerBits > MAX_BITS)
	{
		SetLastError(IDS_SIGINTEGERTOOBIG);
		ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
		goto CheckEnd;
	}
	__asm
	{
		mov		esi,lpTempEDI
		mov		ecx,dwRsaIntegerBits
		add		ecx,7
		shr		ecx,3
		mov		dwRsaIntegerBytes,ecx
		mov		edi,offset Temp2
		rep		movsb
	}
	CircleSwap((LPBYTE)&Temp2,dwRsaIntegerBytes);

	// Search for the public key to decrypt the rsa integer with.
	//...........................................................
	li.QuadPart = SearchMyFileBinary(lpIndexFile1,&KeySID,KEY_ID_SIZE,hIdxHandle1,0,
								     &KeyIdSearch);
	if (li.QuadPart == -1)
	{
		goto CheckEnd;
	}
	if (li.QuadPart == 0)
	{
		SetLastError(IDS_NOPUBLICKEYTODECRYPTSIG);
		ErrorProcedure((LPTSTR)lpRingFile1,IDS_READ,MB_OK);
		goto CheckEnd;
	}
		// We have a public key to decrypt the ske packet with.
	//.....................................................
	dwIdxOffset1 = li.HighPart;
	dwBytesRead = ReadIndex1();
	if (dwBytesRead == -1)
	{
		goto CheckEnd;
	}
	dwBytesRead = ReadRecord1();
	if (dwBytesRead == -1)
	{
		goto CheckEnd;
	}
	EmptyTheMessageQue();
	
	// Get the user id in case we have a red alert.
	//.............................................
	ZeroMemory(&TempUserId,sizeof(TempUserId));
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		lpKeyBufferDup1,edi
	}
	// Search for the first user id.
	//..............................
	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		CtbByte,al
		}
		if (CtbByte != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup1,edi
				mov		dwIdLength,eax
			}
			break;
		}
	}
	CopyMemory(&TempUserId,lpKeyBufferDup1,dwIdLength);
	EmptyTheMessageQue();

	liPublicKeyExpire.QuadPart = 0;
	
	// Now setup modulus n and exponet e.
	//...................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		cl,byte ptr [edi]
		add		edi,CTB_SIZE
		mov		edx,1
		and		cl,LENGTH_MASK
		shl		edx,cl
		add		edi,edx
		add		edi,VERSION_SIZE
		mov		ebx,dword ptr [edi]
		bswap	ebx

		// Get the high 7 bits of the timestamp.
		//......................................
		mov		esi,dword ptr [edi+6]
		and		esi,0x00ff
		shr		esi,1

		add		edi,TIMESTAMP_SIZE
		movzx	eax,word ptr [edi]
		xchg	ah,al
		cmp		eax,0
		je		L19
		xor		edx,edx
		mov		ecx,SECS_PER_DAY
		mul		ecx
		add		eax,ebx
		adc		edx,esi
		mov		liPublicKeyExpire.LowPart,eax
		mov		liPublicKeyExpire.HighPart,edx

	  L19:
		add		edi,(VALIDITY_SIZE + ALGORITHM_SIZE)

		// Setup modulus n.
		//.................
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ah,al
		mov		dwN_Bits,eax
		add		eax,7
		shr		eax,3
		mov		dwN_Bytes,eax
		push	edi
		mov		esi,edi
		mov		ecx,eax
		mov		edi,offset Modulus_N
		rep		movsb
		pop		edi
		add		edi,dwN_Bytes

		// Setup exponent e.
		//..................
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ah,al
		add		eax,7
		shr		eax,3
		mov		dwE_Bytes,eax
		mov		lpTempEDI,edi
		mov		esi,edi
		mov		ecx,eax
		mov		edi,offset E_Temp
		rep		movsb
	}
	CircleSwap((LPBYTE)&Modulus_N,dwN_Bytes);
	CircleSwap((LPBYTE)&E_Temp,dwE_Bytes);

	// Check to see if this key is disabled or not. Get the trust
	// packet following the key packet.
	//...........................................................
	__asm
	{
		mov		edi,lpTempEDI
		add		edi,dwE_Bytes
		mov		cl,byte ptr [edi]
		add		edi,CTB_SIZE
		and		cl,LENGTH_MASK
		mov		edx,1
		shr		edx,cl
		add		edi,edx
		mov		lpTempEDI,edi
	}
	if (*lpTempEDI & DISABLED_BIT)
	{
		RedAlert();
	}
	else if (liPublicKeyExpire.QuadPart != 0)
	{
		if (liMySigTimestamp.QuadPart > liPublicKeyExpire.QuadPart)
		{
			RedAlert();
		}
	}
	// Make sure modulus n is greater than the rsa integer.
	//.....................................................
	if (dwRsaIntegerBits > dwN_Bits)
	{
	  RsaIntegerError:
		SetLastError(IDS_RSAINTEGERINSKEGTMODNINPUBKEY);
		ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
		goto CheckEnd;
	}
	// If the bits are equal, compare the actual variables.
	//.....................................................
	if (dwRsaIntegerBits == dwN_Bits)
	{
		dwResult = MpCompareDW((LPBYTE)&Modulus_N,(LPBYTE)&Temp2,MAX_MOD_DWORD);
		if (dwResult != -1)
		{
			goto RsaIntegerError;
		}
	}
	// Decipher the rsa integer.
	//..........................
	bError = RsaPubDec((LPBYTE)&Temp1,(LPBYTE)&Temp2,(LPBYTE)&E_Temp,
					  (LPBYTE)&Modulus_N,dwN_Bytes);
	if (bError)
	{
	  PubDecError:
		SetLastError(IDS_RSAPUBDECFAILED);
		ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
		goto CheckEnd;
	}
	// Make sure the size of the returned data is correct.
	//....................................................
	if (dwCountBytes != MD5_DIGEST_SIZE && dwCountBytes != SHA_DIGEST_SIZE &&
		dwCountBytes != SHA512_DIGEST_SIZE)
	{
		goto PubDecError;
	}
	// Store the type of message digest used.
	//.......................................
	dwDigestType = SHA512_ENCRYPTED;
	if (dwCountBytes == MD5_DIGEST_SIZE)
	{
		dwDigestType = MD_ENCRYPTED;
	}
	else if (dwCountBytes == SHA_DIGEST_SIZE)
	{
		dwDigestType = SHA_ENCRYPTED;
	}
	// Check the first 2 bytes of the md5 or sha to see if they match
	// the ones in the ske packet.
	//...............................................................
	if (*lpMd5_2_Ptr != *Temp1 || *(lpMd5_2_Ptr+1) != *(Temp1+1))
	{
		goto PubDecError;
	}
	// Now we have to get the file to check the signature on.
	//.......................................................
	if (!bSigInClipboard)
	{
		CopyMemory(&szCheckFile,&szDestination,MAX_PATH);
		PathRemoveExtension((LPTSTR)&szCheckFile);

		// See if we can find the file to check.
		//......................................
		hSearch = FindFirstFile((LPCTSTR)&szCheckFile,&wfd);

		if (hSearch != INVALID_HANDLE_VALUE)
		{
			FindClose(hSearch);
			bAskForFile = FALSE;
		}
	}
	if (bAskForFile)
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		InitializeOFN(&ofn,SAVE_SOURCE);
		ZeroMemory(&szCheckFile,MAX_PATH);

		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szCheckFile;
		ofn.nMaxFile = sizeof(szCheckFile);
		ofn.hwndOwner = hMainWindow;
		ofn.hInstance = hInst;
		ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html]\0*.htm;*.html\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select File To Check");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
		ofn.lpfnHook = MyOFNHookProc;
		ofn.lpstrDefExt = NULL;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto CheckEnd;
		}
		SaveDirName((LPBYTE)&szCheckFile,SAVE_SOURCE,TRUE);
	}
	// We have our file to check.
	//...........................
	ZeroMemory(&Temp2,(MAX_MOD_SLOP*2));

	if (dwDigestType == MD_ENCRYPTED)
	{
		// Calculate the md5 of the decrypted file.
		//.........................................
		bResult = FileMd5((LPBYTE)&szCheckFile,(LPBYTE)&Md5ForFile,
						   lpMd5AppendPtr,dwMd5AppendLength);
		CopyMemory(&Temp2,&Md5ForFile,MD5_DIGEST_SIZE);
	}
	else if (dwDigestType == SHA_ENCRYPTED)
	{
		bResult = FileSha((LPBYTE)&szCheckFile,(LPBYTE)&ShaForFile,
						   lpMd5AppendPtr,dwMd5AppendLength);
		CopyMemory(&Temp2,&ShaForFile,SHA_DIGEST_SIZE);
		bWeHaveSha = TRUE;
	}
	else
	{
		bResult = FileSha512((LPBYTE)&szCheckFile,(LPBYTE)&Sha512ForFile,
						      lpMd5AppendPtr,dwMd5AppendLength);
		CopyMemory(&Temp2,&Sha512ForFile,SHA512_DIGEST_SIZE);
	}
	if (!bResult)
	{
		SetLastError(IDS_SIGCHECKFILEERROR);
		ErrorProcedure((LPTSTR)&szCheckFile,IDS_READ,MB_OK);
		goto CheckEnd;
	}
	if (dwDigestType == MD_ENCRYPTED)
	{
		// Compare the computed md5 with the md5 in the ske packet.
		//.........................................................
		iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Temp1,MD5_DIGEST_SIZE,
							   (LPCTSTR)&Md5ForFile,MD5_DIGEST_SIZE);
	}
	else if (dwDigestType == SHA_ENCRYPTED)
	{
		// Compare the computed sha with the sha in the ske packet.
		//.........................................................
		iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Temp1,SHA_DIGEST_SIZE,
							   (LPCTSTR)&ShaForFile,SHA_DIGEST_SIZE);
	}
	else
	{
		// Compare the computed sha512 with the sha in the ske packet.
		//............................................................
		iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Temp1,SHA512_DIGEST_SIZE,
							   (LPCTSTR)&Sha512ForFile,SHA512_DIGEST_SIZE);
	}
	bSigsTheSame = FALSE;
	if (iResult == CSTR_EQUAL)
	{
		bSigsTheSame = TRUE;
	}
	if (dwDigestType != SHA512_ENCRYPTED)
	{
		iResult = DialogBox(hInst,TEXT("CHECKFILE"),hMainWindow,(DLGPROC)CheckFileProc);
	}
	else
	{
		iResult = DialogBox(hInst,TEXT("CHECK512FILE"),hMainWindow,(DLGPROC)CheckFile512Proc);
	}
	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
	}

	CheckEnd:

	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	if (lpMyClipboard)
	{
		ZeroMemory(lpMyClipboard,dwLength);
		DeallocateMemory(lpMyClipboard);
	}
	if (lpSigBuffer)
	{
		ZeroMemory(lpSigBuffer,dwSigSize);
		DeallocateMemory(lpSigBuffer);
	}
	if (lpDestination)
	{
		ZeroMemory(lpDestination,dwDestSize);
		DeallocateMemory(lpDestination);
	}
	if (hSigFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hSigFile);
	}
	// If it is a temporary file from the clipboard, delete it.
	//.........................................................
	if (bSigInClipboard)
	{
		DeleteMyFile((LPTSTR)&szDestination);
	}

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Set a bold font for a dialog box control.
//..........................................
VOID SetBoldFont(HWND hDlg, DWORD dwControl, DWORD dwControl2)
{
	hDlgFont = 0;

	if ((hDlgFont = (HFONT)SendMessage(hDlg,WM_GETFONT,0,0L)) != NULL)
	{
		if (GetObject(hDlgFont,sizeof(LOGFONT),(LPSTR)&lFont) != 0)
		{
			lFont.lfWeight = FW_BOLD;
            if ((hDlgFont = CreateFontIndirect(&lFont)) != NULL)
			{
				SendDlgItemMessage(hDlg,dwControl,WM_SETFONT,(WPARAM)hDlgFont,0L);

				if (dwControl2)
				{
					SendDlgItemMessage(hDlg,dwControl2,WM_SETFONT,(WPARAM)hDlgFont,0L);
				}
			}
		}
	}
}

// Set a bold font for a dialog box control.
//..........................................
VOID SetBoldFont2(HWND hDlg, DWORD dwControl)
{
	hDlgFont2 = 0;

	if ((hDlgFont2 = (HFONT)SendMessage(hDlg,WM_GETFONT,0,0L)) != NULL)
	{
		if (GetObject(hDlgFont2,sizeof(LOGFONT),(LPSTR)&lFont2) != 0)
		{
			lFont2.lfWeight = FW_BOLD;
            if ((hDlgFont2 = CreateFontIndirect(&lFont2)) != NULL)
			{
				SendDlgItemMessage(hDlg,dwControl,WM_SETFONT,(WPARAM)hDlgFont2,0L);
			}
		}
	}
}

// CALLBACK procedure for displaying the final results of checking a file's signature.
//....................................................................................
LRESULT CALLBACK CheckFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	LPBYTE		lpCheckSigName;
	LPBYTE		lpSigExt;
	DWORD		dwFingerPrintValue;
	LPBYTE		lpReturnAddress;
	DWORD		dwResult;
	TCHAR		szBuffer[256];
	TCHAR		szBuffer1[80];
	TCHAR		szBuffer2[80];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the results font to bold.
			//..............................
			SetBoldFont(hDlg,IDC_SIG_RESULT,0);

			// Setup the icon and name of the file to check.
			//..............................................
			lpCheckSigName = PathFindFileName((LPCTSTR)&szCheckFile);
			lpSigExt = PathFindExtension((LPCTSTR)&szCheckFile);
			SetDlgItemText(hDlg,IDC_SIG_FILE1,(LPCTSTR)lpCheckSigName);

			hIcon2 = FindMyIcon((LPBYTE)&szCheckFile,lpSigExt);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon2)
			{
				hIcon2 = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);

			// Set the name of the signature file.
			//....................................
			if (!bSigInClipboard)
			{
				lpCheckSigName = PathFindFileName((LPCTSTR)&szDestination);
				SetDlgItemText(hDlg,IDC_SIG_FILE2,(LPCTSTR)lpCheckSigName);
			}
			else
			{
				SetDlgItemText(hDlg,IDC_SIG_FILE2,(LPCTSTR)lpszClipboard);
			}
			// Set the user id of the public key.
			//...................................
			SetDlgItemText(hDlg,IDC_SIG_ID,(LPCTSTR)&TempUserId);

			// Set the data and time the signature was created.
			//.................................................
			TimestampToDateTime(liMySigTimestamp.QuadPart,&stCreated);
			GetDateFormat(LOCALE_USER_DEFAULT,0,&stCreated,"ddd',' dd MMM yyyy",szBuffer1,80);
			StringCbPrintf((LPTSTR)&szBuffer2,sizeof(szBuffer),szTime,stCreated.wHour,
						    &TimeSep,stCreated.wMinute,&TimeSep,stCreated.wSecond);
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szKeyDateTime,
							&szBuffer1,&szBuffer2);
			SetDlgItemText(hDlg,IDC_SIG_CREATED,(LPCTSTR)&szBuffer);

			// Byte swap the digests for displaying.
			//......................................
			__asm
			{
				mov		edi,offset Temp1
				mov		eax,dword ptr [edi]
				mov		ebx,dword ptr [edi+4]
				mov		ecx,dword ptr [edi+8]
				mov		edx,dword ptr [edi+12]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi],eax
				mov		dword ptr [edi+4],ebx
				mov		dword ptr [edi+8],ecx
				mov		dword ptr [edi+12],edx

				// Just in case we are doing the Sha digest.
				//..........................................
				cmp		bWeHaveSha,1
				jne		L1
				mov		eax,dword ptr [edi+16]
				bswap	eax
				mov		dword ptr [edi+16],eax

				// Now do the digest for the file.
				//................................
			L1:	mov		edi,offset Temp2
				mov		eax,dword ptr [edi]
				mov		ebx,dword ptr [edi+4]
				mov		ecx,dword ptr [edi+8]
				mov		edx,dword ptr [edi+12]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi],eax
				mov		dword ptr [edi+4],ebx
				mov		dword ptr [edi+8],ecx
				mov		dword ptr [edi+12],edx

				// Just in case we are doing the Sha digest.
				//..........................................
				cmp		bWeHaveSha,1
				jne		L2
				mov		eax,dword ptr [edi+16]
				bswap	eax
				mov		dword ptr [edi+16],eax
			}
		L2:	FillMemory(Line1,75,0x20);

			__asm
			{	
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,Line1);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+4]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+8]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+12]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			if (bWeHaveSha)
			{
				__asm
				{
					mov		esi,offset Temp1
					mov		eax,dword ptr [esi+16]
					mov		dwFingerPrintValue,eax
				}
				lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);
			}
			*lpReturnAddress = 0;

			if (bWeHaveSha)
			{
				SetDlgItemText(hDlg,IDC_SIG_DIGEST,TEXT("Sig Sha1:"));
				SetDlgItemText(hDlg,IDC_FILE_DIGEST,TEXT("File Sha1:"));
			}
			else
			{
				SetDlgItemText(hDlg,IDC_SIG_DIGEST,TEXT("Sig Md5:"));
				SetDlgItemText(hDlg,IDC_FILE_DIGEST,TEXT("File Md5:"));
			}
			SetDlgItemText(hDlg,IDC_SIG_DATA,(LPCTSTR)&Line1);

			// Do the file's digest.
			//......................
			FillMemory(Line1,75,0x20);

			__asm
			{	
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,Line1);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+4]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+8]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+12]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			if (bWeHaveSha)
			{
				__asm
				{
					mov		esi,offset Temp2
					mov		eax,dword ptr [esi+16]
					mov		dwFingerPrintValue,eax
				}
				lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);
			}
			*lpReturnAddress = 0;

			SetDlgItemText(hDlg,IDC_FILE_DATA,(LPCTSTR)&Line1);

			// Now do the final results.
			//..........................
			if (bSigsTheSame)
			{
				dwResult = IDS_SIGSMATCH;
			}
			else
			{
				dwResult = IDS_SIGSNOMATCH;
			}
			LoadString(hInst,(UINT)dwResult,(LPTSTR)&szBuffer,sizeof(szBuffer));
			SetDlgItemText(hDlg,IDC_SIG_RESULT,(LPCTSTR)&szBuffer);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDCANCEL:
				case IDOK:
				{
					if (hDlgFont)
					{
						DeleteObject(hDlgFont);
						hDlgFont = 0;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for displaying the final results of checking a file's Sha512 signature.
//...........................................................................................
LRESULT CALLBACK CheckFile512Proc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	LPBYTE		lpCheckSigName;
	LPBYTE		lpSigExt;
	DWORD		dwFingerPrintValue;
	LPBYTE		lpReturnAddress;
	DWORD		dwResult;
	TCHAR		szBuffer[256];
	TCHAR		szBuffer1[80];
	TCHAR		szBuffer2[80];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the results font to bold.
			//..............................
			SetBoldFont(hDlg,IDC_SIG_RESULT,0);

			// Setup the icon and name of the file to check.
			//..............................................
			lpCheckSigName = PathFindFileName((LPCTSTR)&szCheckFile);
			lpSigExt = PathFindExtension((LPCTSTR)&szCheckFile);
			SetDlgItemText(hDlg,IDC_SIG_FILE1,(LPCTSTR)lpCheckSigName);

			hIcon2 = FindMyIcon((LPBYTE)&szCheckFile,lpSigExt);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon2)
			{
				hIcon2 = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);

			// Set the name of the signature file.
			//....................................
			if (!bSigInClipboard)
			{
				lpCheckSigName = PathFindFileName((LPCTSTR)&szDestination);
				SetDlgItemText(hDlg,IDC_SIG_FILE2,(LPCTSTR)lpCheckSigName);
			}
			else
			{
				SetDlgItemText(hDlg,IDC_SIG_FILE2,(LPCTSTR)lpszClipboard);
			}
			// Set the user id of the public key.
			//...................................
			SetDlgItemText(hDlg,IDC_SIG_ID,(LPCTSTR)&TempUserId);

			// Set the data and time the signature was created.
			//.................................................
			TimestampToDateTime(liMySigTimestamp.QuadPart,&stCreated);
			GetDateFormat(LOCALE_USER_DEFAULT,0,&stCreated,"ddd',' dd MMM yyyy",szBuffer1,80);
			StringCbPrintf((LPTSTR)&szBuffer2,sizeof(szBuffer2),szTime,stCreated.wHour,
						    &TimeSep,stCreated.wMinute,&TimeSep,stCreated.wSecond);
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szKeyDateTime,
						    &szBuffer1,&szBuffer2);
			SetDlgItemText(hDlg,IDC_SIG_CREATED,(LPCTSTR)&szBuffer);

			// Byte swap the digests for displaying.
			//......................................
			__asm
			{
				mov		edi,offset Temp1
				mov		eax,dword ptr [edi]
				mov		ebx,dword ptr [edi+4]
				mov		ecx,dword ptr [edi+8]
				mov		edx,dword ptr [edi+12]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi],eax
				mov		dword ptr [edi+4],ebx
				mov		dword ptr [edi+8],ecx
				mov		dword ptr [edi+12],edx

				mov		eax,dword ptr [edi+16]
				mov		ebx,dword ptr [edi+20]
				mov		ecx,dword ptr [edi+24]
				mov		edx,dword ptr [edi+28]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi+16],eax
				mov		dword ptr [edi+20],ebx
				mov		dword ptr [edi+24],ecx
				mov		dword ptr [edi+28],edx

				mov		eax,dword ptr [edi+32]
				mov		ebx,dword ptr [edi+36]
				mov		ecx,dword ptr [edi+40]
				mov		edx,dword ptr [edi+44]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi+32],eax
				mov		dword ptr [edi+36],ebx
				mov		dword ptr [edi+40],ecx
				mov		dword ptr [edi+44],edx

				mov		eax,dword ptr [edi+48]
				mov		ebx,dword ptr [edi+52]
				mov		ecx,dword ptr [edi+56]
				mov		edx,dword ptr [edi+60]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi+48],eax
				mov		dword ptr [edi+52],ebx
				mov		dword ptr [edi+56],ecx
				mov		dword ptr [edi+60],edx

				// Now do the digest for the file.
				//................................
				mov		edi,offset Temp2
				mov		eax,dword ptr [edi]
				mov		ebx,dword ptr [edi+4]
				mov		ecx,dword ptr [edi+8]
				mov		edx,dword ptr [edi+12]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi],eax
				mov		dword ptr [edi+4],ebx
				mov		dword ptr [edi+8],ecx
				mov		dword ptr [edi+12],edx

				mov		eax,dword ptr [edi+16]
				mov		ebx,dword ptr [edi+20]
				mov		ecx,dword ptr [edi+24]
				mov		edx,dword ptr [edi+28]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi+16],eax
				mov		dword ptr [edi+20],ebx
				mov		dword ptr [edi+24],ecx
				mov		dword ptr [edi+28],edx

				mov		eax,dword ptr [edi+32]
				mov		ebx,dword ptr [edi+36]
				mov		ecx,dword ptr [edi+40]
				mov		edx,dword ptr [edi+44]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi+32],eax
				mov		dword ptr [edi+36],ebx
				mov		dword ptr [edi+40],ecx
				mov		dword ptr [edi+44],edx

				mov		eax,dword ptr [edi+48]
				mov		ebx,dword ptr [edi+52]
				mov		ecx,dword ptr [edi+56]
				mov		edx,dword ptr [edi+60]
				bswap	eax
				bswap	ebx
				bswap	ecx
				bswap	edx
				mov		dword ptr [edi+48],eax
				mov		dword ptr [edi+52],ebx
				mov		dword ptr [edi+56],ecx
				mov		dword ptr [edi+60],edx
			}
			FillMemory(LongLine1,120,0x20);
			FillMemory(LongLine2,120,0x20);

			__asm
			{	
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,LongLine1);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+4]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+8]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+12]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+16]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+20]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+24]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+28]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			*lpReturnAddress = 0;

			// Now do the second line.
			//........................
			__asm
			{	
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+32]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,LongLine2);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+36]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+40]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+44]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+48]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+52]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+56]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp1
				mov		eax,dword ptr [esi+60]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			*lpReturnAddress = 0;

			SetDlgItemText(hDlg,IDC_SIG_DATA,(LPCTSTR)&LongLine1);
			SetDlgItemText(hDlg,IDC_SIG_DATA1,(LPCTSTR)&LongLine2);

			// Do the file's digest.
			//......................
			FillMemory(LongLine1,120,0x20);
			FillMemory(LongLine2,120,0x20);

			__asm
			{	
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,LongLine1);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+4]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+8]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+12]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+16]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+20]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+24]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+28]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			*lpReturnAddress = 0;

			// Now do the second line.
			//........................
			__asm
			{	
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+32]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,LongLine2);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+36]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+40]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+44]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+48]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+52]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+56]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			__asm
			{
				mov		esi,offset Temp2
				mov		eax,dword ptr [esi+60]
				mov		dwFingerPrintValue,eax
			}
			lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

			*lpReturnAddress = 0;

			SetDlgItemText(hDlg,IDC_FILE_DATA,(LPCTSTR)&LongLine1);
			SetDlgItemText(hDlg,IDC_FILE_DATA1,(LPCTSTR)&LongLine2);

			// Now do the final results.
			//..........................
			if (bSigsTheSame)
			{
				dwResult = IDS_SIGSMATCH;
			}
			else
			{
				dwResult = IDS_SIGSNOMATCH;
			}
			LoadString(hInst,(UINT)dwResult,(LPTSTR)&szBuffer,sizeof(szBuffer));
			SetDlgItemText(hDlg,IDC_SIG_RESULT,(LPCTSTR)&szBuffer);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDCANCEL:
				case IDOK:
				{
					if (hDlgFont)
					{
						DeleteObject(hDlgFont);
						hDlgFont = 0;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Special hook for open file dialog for checking a signature file.
//.................................................................
UINT CALLBACK MyCheckOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			// The file is in the clipboard.
			//..............................
			bSigInClipboard = FALSE;
			
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_SIGN_CLIPBOARD:
				{
					bSigInClipboard = TRUE;
					PostMessage(GetParent(hDlg),WM_COMMAND,IDCANCEL,0);
					return(TRUE);
				}
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_SIGN_CLIPBOARD)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}


// Sign a file with a detached signature. It may be sent to a file
// or the clipboard.
//................................................................
VOID SignAFile()
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liRecipientsTimestamp;
	LARGE_INTEGER	liCurrentTimestamp;
	ULARGE_INTEGER	uliTime;
	DWORD			dwOldHelpTopic;
	OPENFILENAME	ofn;
	TCHAR			szSigFile[MAX_PATH];
	HANDLE			hSigFile = 0;
	DWORD			dwCtb_Byte;
	DWORD			dwTempEAX;
	DWORD			dwEncModNBytes;
	DWORD			dwArmorLines;
	DWORD			dwErrCode;
	DWORD			dwMemNeeded;
	DWORD			dwCurrentSize;
	DWORD			dwArmorSize;
	DWORD			dwBytesWritten;
	HANDLE			lpClipboardMem = 0;
	HANDLE			lpClipboardMemDup;
	HGLOBAL			hClipboardMem;
	HANDLE			hClipboard;
	BOOL			bError = TRUE;
	BOOL			bMem;
	BOOL			bResult;
	int				iResult;
	int				iTemp;
	DWORD			dwSecretElements;
	DWORD			dwCDStructLength;
	DWORD			dwBytesRead;
	LPBYTE			lpTempEDI;
	LPBYTE			lpTempName;
	BOOL			bKeyDisabled;
	TCHAR			szBuffer[1024];
	TCHAR			szFmt[256];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_SIGN_FILE);
	bExport = TRUE;

	if (BPC())
	{
		goto SignEnd;
	}
	// Setup the default header and footer.
	//.....................................
	__asm
	{
		mov		esi,offset szBeginTsc
		mov		edi,offset SigHeader
		mov		ecx,14
		rep		movsb

		mov		esi,offset szBeginTsc
		mov		edi,offset SigHeaderP
		mov		ecx,14
		rep		movsb

		mov		esi,offset szEndTsc
		mov		edi,offset SigFooter
		mov		ecx,12
		rep		movsb
	}
	// Setup the signature headers.
	//.............................
	skh.CTB = (CTB_SKE_PACKET | LENGTH_2);
	skh.VERSION = VERSION_NEW;
	skh.CLASS = SIG_MSG_BINARY;
	skh.RSA_ALGOR = RSA_ALGORITHM;
	
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szDestination;
	ofn.nMaxFile = sizeof(szDestination);
	ofn.hwndOwner = hMainWindow;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html]\0*.htm;*.html\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a File to Sign");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
				 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY |
				 OFN_ENABLETEMPLATE);
	if (bWin2000OrGreater)
	{
		ofn.lpTemplateName = TEXT("SIGNAFILENEW");
	}
	else
	{
		ofn.lpTemplateName = TEXT("SIGNAFILE");
	}
	ofn.lpfnHook = MySignOFNHookProc;
	ofn.lpstrDefExt = NULL;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;
	ZeroMemory(&szDestination,MAX_PATH);

	if (!GetOpenFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_GET_FILES);
		goto SignEnd;
	}
	SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,TRUE);

	// If we are sending it to a file set up the file name.
	//.....................................................
	if (bSendToFile)
	{
		CopyMemory(&szSigFile,&szDestination,MAX_PATH);

		// Check to make sure we can add an extension.
		//............................................
		if (lstrlen((LPCTSTR)&szSigFile) + sizeof(szSigExt) > MAX_PATH)
		{
			SetLastError(IDS_SIGNAMEPLUSEXTTOOLONG);
			ErrorProcedure((LPTSTR)&szSigFile,IDS_CREATE_OPEN,MB_OK);
			goto SignEnd;
		}
		StringCbCatEx((LPTSTR)&szSigFile,sizeof(szSigFile),(LPCTSTR)&szSigExt,NULL,NULL,
					   dwStringSafeFlag);

		hSigFile = CreateMyFile((LPTSTR)&szSigFile,GENERIC_READ | GENERIC_WRITE,0,NULL,
								CREATE_NEW,FILE_ATTRIBUTE_ARCHIVE,NULL);
		if (!hSigFile)
		{
			goto SignEnd;
		}
	}
	else
	{
		bTextOutput = FALSE;
	}
	// Select a secret key to sign with.
	//..................................
	dwSecretElements = dwSecretIds;
	dwCDStructLength = sizeof(CD_STRUCT);
	dwCDLength = sizeof(CD_STRUCT);

	// Allocate memory for the three buffers we will use and the
	// central directories for the public and secret key rings.
	//..........................................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);
	lpSecretKeyCentralDir = AllocateMemory(dwSecretIds * sizeof(CD_STRUCT));
	lpPublicKeyCentralDir = AllocateMemory(dwPublicIds * sizeof(CD_STRUCT));

	if (!lpKeyBuffer1 || !lpKeyBuffer2 || !lpKeyBuffer3 ||
		!lpSecretKeyCentralDir || !lpPublicKeyCentralDir)
	{
		goto SignEnd;
	}
	// Build the central directory for the secret key ring.
	// Use the user id index in group one to keep the keys
	// in order. 
	//....................................................
	SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_ONE);
	bResult = BuildCentralDirectory(lpSecretKeyCentralDir,TRUE);
	if (!bResult)
	{
		goto SignEnd;
	}
	// Build the central directory for the public key ring.
	// Use the user id index in group one to keep the keys
	// in order. Use group two for the key id index.
	//.....................................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);
	bResult = BuildCentralDirectory(lpPublicKeyCentralDir,FALSE);
	if (!bResult)
	{
		goto SignEnd;
	}
	// Make a quick check to mark the secret keys as disabled or not.
	//...............................................................
	lpScratchCentralDir = lpSecretKeyCentralDir;
	while(dwSecretElements != 0)
	{
		// Search for the corresponding public key so we can check
		// if the secret key is disabled.
		//........................................................
		CopyMemory(&KeySID,lpScratchCentralDir->KEY_SIG_ID,KEY_ID_SIZE);

		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto SignEnd;
		}
		if (li.QuadPart != 0)
		{
			// We had a match. See if the public/secret key pair
			// is disabled.
			//..................................................
			dwIdxOffset2 = li.HighPart;
			dwBytesRead = ReadIndex2();
			if (dwBytesRead == -1)
			{
				goto SignEnd;
			}
			dwBytesRead = ReadRecord2();
			if (dwBytesRead == -1)
			{
				goto SignEnd;
			}
			// The public key is in lpKeyBuffer2.
			//...................................
			lpKeyBufferDup2 = lpKeyBuffer2;

			__asm
			{
				mov		edi,lpKeyBufferDup2
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
			}
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
				mov		lpKeyBufferDup2,edi
			}
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup2,edi
			}
			// If the key is disabled, move Yes to the disabled field.
			//........................................................
			if (*lpKeyBufferDup2 & DISABLED_BIT)
			{
				CopyMemory(lpScratchCentralDir->DISABLED,&szYes,lstrlen(&szYes));
			}
		}
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir,eax
		}
		dwSecretElements--;
	}
	SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_TWO);
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);

	// Flush and rewind all the files.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto SignEnd;
	}
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto SignEnd;
	}
	// Mark the secret key to sign the file with.
	//...........................................
	bSingleSelectionOnly = TRUE;
	iItemsSelected = 0;
	lpScratchCentralDir = lpSecretKeyCentralDir;
	MarkType = MARK_KEYS;
	iMaxItems = dwSecretIds;
	iItemCount = dwSecretIds;
	dwEditFunction = 11;
	bResult = MarkTheKeys();
	if (!bResult || iItemsSelected == 0)
	{
		goto SignEnd;
	}
	// Find our selected secret key so we can determine if it is
	// disabled or not.
	//..........................................................
	lpScratchCentralDir = lpSecretKeyCentralDir;
	while(TRUE)
	{
		if (lpScratchCentralDir->STATE)
		{
			break;
		}
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir,eax
		}
	}
	CopyMemory(&CDLine1,lpScratchCentralDir,sizeof(CD_STRUCT));
	CopyMemory(&KeySID,&CDLine1.KEY_SIG_ID,KEY_ID_SIZE);
	CopyMemory(&skh.KEY_ID,&CDLine1.KEY_SIG_ID,KEY_ID_SIZE);

	// Search for the corresponding public key so we can check
	// if the secret key is disabled.
	//........................................................
	li.QuadPart = SearchMyFileBinary(lpIndexFile1,&KeySID,KEY_ID_SIZE,hIdxHandle1,0,
									 &KeyIdSearch);
	if (li.QuadPart == -1 || li.QuadPart == 0)
	{
		SetLastError(IDS_CANNOTDETERMINEIFSECRETKEYDISABLED);
		ErrorProcedure(lpRingFile2,IDS_READ,MB_OK);
		goto SignEnd;
	}
	// We had a match. See if the public/secret key pair
	// is disabled.
	//..................................................
	dwIdxOffset1 = li.HighPart;
	dwBytesRead = ReadIndex1();
	if (dwBytesRead == -1)
	{
		goto SignEnd;
	}
	dwBytesRead = ReadRecord1();
	if (dwBytesRead == -1)
	{
		goto SignEnd;
	}
	bKeyDisabled = FALSE;

	// The public key is in lpKeyBuffer1.
	//...................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		lpTempEDI,edi
		add		edi,eax
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		lpKeyBufferDup1,edi
	}
	// If the key is disabled, unmark it.
	//...................................
	if (*lpKeyBufferDup1 & DISABLED_BIT)
	{
		lpScratchCentralDir->STATE = 0;
		bKeyDisabled = TRUE;
	}
	else
	{
		// Use liRecipientsTimestamp to do our validity period
		// calculations.
		//....................................................
		liRecipientsTimestamp.QuadPart = 0;

		// See if the validity period has expired.
		// If it has, unmark it.
		//........................................
		__asm
		{
			mov		edi,lpTempEDI
			add		edi,VERSION_SIZE
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		liRecipientsTimestamp.LowPart,eax

			// Get the high order 7 bits of the timestamp.
			//............................................
			mov		eax,dword ptr [edi+6]
			and		eax,0x00ff
			shr		eax,1
			mov		liRecipientsTimestamp.HighPart,eax

			add		edi,TIMESTAMP_SIZE
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwTempEAX,eax
		}
		// If we have a validity period.
		//..............................
		if (dwTempEAX)
		{
			__asm
			{
				xor		edx,edx
				mov		eax,dwTempEAX
				mov		ecx,SECS_PER_DAY
				mul		ecx
				add		liRecipientsTimestamp.LowPart,eax
				adc		liRecipientsTimestamp.HighPart,edx
			}
			// Get the current timestamp and compare.
			//.......................................
			liCurrentTimestamp.QuadPart = GetTimestamp(TRUE);
			if (liRecipientsTimestamp.QuadPart  < liCurrentTimestamp.QuadPart)
			{
				lpScratchCentralDir->STATE = 0;
				bKeyDisabled = TRUE;
			}
		}
	}
	if (bKeyDisabled)
	{
		SetLastError(IDS_SELECTEDSECRETKEYISDISABLED);
		ErrorProcedure(lpRingFile2,IDS_READ,MB_OK);
		goto SignEnd;
	}
	// Make sure we know the pass phrase to the secret key.
	// Put the secret key in lpKeyBuffer2.
	//.....................................................
	dwIdxOffset2 = CDLine1.IDX_OFFS;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1)
	{
		goto SignEnd;
	}
	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1)
	{
		goto SignEnd;
	}
	CopyMemory(&TempUserId,CDLine1.ID,sizeof(TempUserId));
	iResult = SignSetup(lpKeyBuffer2,IDS_NOSIGNFILE,IDS_NOSIGNFILEPP);
	if (!iResult)
	{
		goto SignEnd;
	}
	dwEncModNBytes = dwN_Bytes;

	if (bUseMd5)
	{
		skh.APPEND_LENGTH = SKE_APPEND_LGTH;
		skh.MD5_ALGOR = MD5_ALGORITHM;
	}
	else
	{
		skh.APPEND_LENGTH = SKE_SHA_APPEND_LGTH;

		if (dwN_Bytes > SHA512_MIN_KEY_SIZE)
		{
			skh.MD5_ALGOR = SHA512_ALGORITHM;
		}
		else
		{
			skh.MD5_ALGOR = SHA_ALGORITHM;
		}
	}
	// Ask if we want to create the signature with PGP compatible header and footer.
	//..............................................................................
	if (bUseMd5 && (!bSendToFile || bTextOutput))
	{
		lpTempName = PathFindFileName((LPCTSTR)&szDestination);
		LoadString(hInst,IDS_PGPSIGHDR,(LPTSTR)&szFmt,sizeof(szFmt));
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szFmt,lpTempName,
					    &CDLine1.ID);
		iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)&szBuffer,
								 MB_ICONQUESTION | MB_HELP | MB_YESNOCANCEL,
								 MB_ICONQUESTION,0);
		if (iResult == IDYES)
		{
			__asm
			{
				mov		esi,offset szBeginPgp
				mov		edi,offset SigHeader
				mov		ecx,14
				rep		movsb

				mov		esi,offset szBeginPgp
				mov		edi,offset SigHeaderP
				mov		ecx,14
				rep		movsb

				mov		esi,offset szEndPgp
				mov		edi,offset SigFooter
				mov		ecx,12
				rep		movsb
			}
		}
		else if (iResult == IDCANCEL)
		{
			goto SignEnd;
		}
	}
	// Setup the modeless dialog box for signing the file.
	//....................................................
	bCancelOperation = FALSE;

	if (bSendToFile)
	{
		hDialogModeLess = CreateDialog(hInst,TEXT("SIGNAFILETOFILE"),hMainWindow,
							      (DLGPROC)SignAFileProc);
	}
	else
	{
		hDialogModeLess = CreateDialog(hInst,TEXT("SIGNAFILETOCLIP"),hMainWindow,
							      (DLGPROC)SignAFileProc);
	}
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto SignEnd;
	}
	// Sign the file using the sha1 digest.
	//.....................................
	uliTime.QuadPart = GetTimestamp(TRUE);

	if (bUseMd5)
	{
		__asm
		{
			mov		eax,uliTime.LowPart
			bswap	eax
			mov		uliTime.LowPart,eax
		}
		skh.TIMESTAMP = uliTime.LowPart;
		bResult = FileMd5((LPBYTE)&szDestination,(LPBYTE)&Md5Digest,
						  (LPBYTE)&skh.CLASS,SKE_APPEND_LGTH);
		if (!bResult)
		{
			goto SignEnd;
		}
		skh.MD5_2_BYTES[0] = Md5Digest[0];
		skh.MD5_2_BYTES[1] = Md5Digest[1];
	}
	else
	{
		// Use the Sha message digest.
		//............................
		__asm
		{
			mov		eax,uliTime.LowPart
			bswap	eax
			mov		uliTime.LowPart,eax
		}
		skh.TIMESTAMP = uliTime.LowPart;

		__asm
		{
			mov		al,skh.RSA_ALGOR
			mov		edx,uliTime.HighPart
			and		edx,0x00ff
			shl		edx,1
			or		al,dl
			mov		skh.RSA_ALGOR,al
		}
		if (skh.MD5_ALGOR == SHA_ALGORITHM)
		{
			bResult = FileSha((LPBYTE)&szDestination,(LPBYTE)&ShaDigest,
							 (LPBYTE)&skh.CLASS,SKE_SHA_APPEND_LGTH);
		}
		else
		{
			bResult = FileSha512((LPBYTE)&szDestination,(LPBYTE)&Sha512Digest,
								(LPBYTE)&skh.CLASS,SKE_SHA_APPEND_LGTH);
		}
		if (!bResult)
		{
			goto SignEnd;
		}
		if (skh.MD5_ALGOR == SHA_ALGORITHM)
		{
			skh.MD5_2_BYTES[0] = ShaDigest[0];
			skh.MD5_2_BYTES[1] = ShaDigest[1];
		}
		else
		{
			skh.MD5_2_BYTES[0] = Sha512Digest[0];
			skh.MD5_2_BYTES[1] = Sha512Digest[1];
		}
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto SignEnd;
	}
	if (bUseMd5)
	{
		RsaPriEnc((LPBYTE)&Temp1,(LPBYTE)&Md5Digest,MD5_DIGEST_SIZE,
				 (LPBYTE)&D_Temp,(LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,
				 (LPBYTE)&U_Temp,dwEncModNBytes);
	}
	else
	{
		if (skh.MD5_ALGOR == SHA_ALGORITHM)
		{
			RsaPriEnc((LPBYTE)&Temp1,(LPBYTE)&ShaDigest,SHA_DIGEST_SIZE,
					 (LPBYTE)&D_Temp,(LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,
					 (LPBYTE)&U_Temp,dwEncModNBytes);
		}
		else
		{
			RsaPriEnc((LPBYTE)&Temp1,(LPBYTE)&Sha512Digest,SHA512_DIGEST_SIZE,
					 (LPBYTE)&D_Temp,(LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,
					 (LPBYTE)&U_Temp,dwEncModNBytes);
		}
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto SignEnd;
	}
	// Setup the mpi bit count.
	//.........................
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		dwTempEAX,eax
	}
	skh.MPI_PREFIX = LOWORD(dwTempEAX);

	dwTempEAX = (dwCountBytes + sizeof(skh) - 3);

	__asm
	{
		mov		eax,dwTempEAX
		xchg	ah,al
		mov		dwTempEAX,eax
	}
	skh.LENGTH = LOWORD(dwTempEAX);

	CircleSwap((LPBYTE)&Temp1,dwCountBytes);

	ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
	CopyMemory(lpKeyBuffer1,&skh,sizeof(SKEY_HDR));
	lpKeyBufferDup1 = lpKeyBuffer1;
	lpKeyBufferDup1 += sizeof(SKEY_HDR);
	CopyMemory(lpKeyBufferDup1,&Temp1,dwCountBytes);

	// Save the size of the signature in dwTempEAX.
	//.............................................
	dwTempEAX = dwCountBytes + sizeof(skh);

	// Convert to radix-64 format if sending to clipboard or text output to file.
	//...........................................................................
	if (!bSendToFile || bTextOutput)
	{
		// Figure out the memory needed for the armor buffer.
		//...................................................
		__asm
		{
			xor		edx,edx
			mov		eax,dwTempEAX
			mov		ecx,48
			div		ecx
			cmp		edx,0
			je		L1
			inc		eax
		L1:	mov		dwArmorLines,eax
		}
		dwMemNeeded = ((dwArmorLines * 66) + 1024);
		dwCurrentSize = dwMemNeeded;
		if (bSendToFile)
		{
			lpClipboardMem = AllocateMemory(dwMemNeeded);
			if (!lpClipboardMem)
			{
				goto SignEnd;
			}
		}
		else
		{	
			// Sending armored buffer to clipboard.
			//.....................................
			hClipboardMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,dwMemNeeded);
			if (hClipboardMem == NULL)
			{
				ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
				goto SignEnd;
			}
			lpClipboardMem = GlobalLock(hClipboardMem);
			if (lpClipboardMem == NULL)
			{
				ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
				GlobalFree(hClipboardMem);
				goto SignEnd;
			}
			ZeroMemory(lpClipboardMem,dwMemNeeded);
		}
		lpClipboardMemDup = lpClipboardMem;
		if (bProgramRegistered)
		{
			CopyMemory(lpClipboardMemDup,&SigHeader,lstrlen((LPCTSTR)&SigHeader));
		}
		else
		{
			CopyMemory(lpClipboardMemDup,&SigHeaderP,lstrlen((LPCTSTR)&SigHeaderP));
		}
		iTemp = lstrlen((LPCTSTR)&SigHeader);
		__asm
		{
			mov		ecx,iTemp
			mov		edi,lpClipboardMemDup
			add		edi,ecx
			mov		lpClipboardMemDup,edi
		}
		// Armor the buffer.
		//..................
		lpClipboardMemDup = ArmorBuffer(lpKeyBuffer1,lpClipboardMemDup,dwTempEAX);

		// Put in the footer.
		//...................
		CopyMemory(lpClipboardMemDup,&SigFooter,lstrlen((LPCTSTR)&SigFooter));

		// Find out the length of the armored buffer.
		//...........................................
		dwArmorSize = (lstrlen(lpClipboardMem) + 1);

		if (bSendToFile)
		{
			bResult = WriteMyFile((LPTSTR)&szSigFile,hSigFile,lpClipboardMem,dwArmorSize,
								   &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto SignEnd;
			}
			bResult = CloseMyHandle((LPTSTR)&szSigFile,hSigFile);
			if (!bResult)
			{
				goto SignEnd;
			}
			hSigFile = 0;
		}
		else
		{
			// Unlock the memory for the clipboard.
			//.....................................
			bMem = GlobalUnlock(hClipboardMem);
			if (!bMem)
			{
				dwErrCode = GetLastError();
				if (dwErrCode != NO_ERROR)
				{
					SetLastError(dwErrCode);
					ErrorProcedure(lpszClipboard,IDS_UNLOCKMEMORY,MB_OK);
					goto SignEnd;
				}
			}
			// Open the Clipboard.
			//....................
			bResult = OpenClipboard(hMainWindow);
			if (!bResult)
			{
				ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
				goto SignEnd;
			}
			bResult = EmptyClipboard();
			if (!bResult)
			{
				ErrorProcedure(lpszClipboard,IDS_EMPTYCLIPBOARD,MB_OK);
				goto SignEnd;
			}
			hClipboard = SetClipboardData(CF_TEXT,hClipboardMem);
			if (!hClipboard)
			{
				ErrorProcedure(lpszClipboard,IDS_SETCLIPBOARD,MB_OK);
			}
			bResult = CloseClipboard();
			if (!bResult || !hClipboard)
			{
				goto SignEnd;
			}
		}
	}
	else
	{
		// Send the binary key to disk.
		//.............................
		bResult = WriteMyFile((LPTSTR)&szSigFile,hSigFile,lpKeyBuffer1,dwTempEAX,
							  &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto SignEnd;
		}
		bResult = CloseMyHandle((LPTSTR)&szSigFile,hSigFile);
		if (!bResult)
		{
			goto SignEnd;
		}
		hSigFile = 0;
	}
	bError = FALSE;

	// Change the message text to signature calcs completed.
	//......................................................
	LoadString(hInst,IDS_SIGCOMPLETED,(LPTSTR)&szFmt,sizeof(szFmt));

	if (bSendToFile)
	{
		StringCbCat((LPTSTR)&szFmt,sizeof(szFmt),TEXT(" Signature file saved to disk."));
	}
	else
	{
		StringCbCat((LPTSTR)&szFmt,sizeof(szFmt),TEXT(" Signature saved to the clipboard."));
	}
	SetDlgItemText(hDialogModeLess,IDC_MYMESSAGE,(LPCTSTR)&szFmt);

	// We are done signing the file. Change the cancel button to OK
	// and wait for input.
	//.............................................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	// Flash our task bar icon if it is minimized.
	//............................................
	FlashMyIcon(TRUE);

	while(TRUE)
	{
		CheckForMessages();

		if (bCancelOperation == TRUE)
		{
			bCancelOperation = FALSE;
			DestroyWindow(hDialogModeLess);
			break;
		}
	}

	SignEnd:

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (lpClipboardMem && bSendToFile)
	{
		ZeroMemory(lpClipboardMem,dwCurrentSize);
		DeallocateMemory(lpClipboardMem);
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	if (lpSecretKeyCentralDir)
	{
		ZeroMemory(lpSecretKeyCentralDir,(dwSecretIds * sizeof(CD_STRUCT)));
		DeallocateMemory(lpSecretKeyCentralDir);
		lpSecretKeyCentralDir = 0;
	}
	if (lpPublicKeyCentralDir)
	{
		ZeroMemory(lpPublicKeyCentralDir,(dwPublicIds * sizeof (CD_STRUCT)));
		DeallocateMemory(lpPublicKeyCentralDir);
		lpPublicKeyCentralDir = 0;
	}
	if (hSigFile)
	{
		bResult = CloseMyHandle((LPTSTR)&szSigFile,hSigFile);
		if (bError && bResult)
		{
			DeleteMyFile((LPTSTR)&szSigFile);
		}
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	bExport = FALSE;
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for signing a file.
//.......................................
LRESULT CALLBACK SignAFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	LPBYTE			lpSigFileName;
	LPBYTE			lpSigExt;
	TCHAR			szTempFile[MAX_PATH];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the IDC_MYMESSAGE control to bold.
			//.......................................
			SetBoldFont(hDlg,IDC_MYMESSAGE,0);

			// Let find the icon for the file.
			//................................
			lpSigExt = PathFindExtension((LPCTSTR)&szDestination);
			hIcon2 = FindMyIcon((LPBYTE)&szDestination,lpSigExt);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon2)
			{
				hIcon2 = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			if (bSendToFile)
			{
				CopyMemory(&szTempFile,&szDestination,MAX_PATH);
				StringCbCat((LPTSTR)&szTempFile,sizeof(szTempFile),(LPCTSTR)&szSigExt);
				lpSigFileName = PathFindFileName((LPCTSTR)&szTempFile);
				SetDlgItemText(hDlg,IDC_FILE2,(LPCTSTR)lpSigFileName);
			}
			// Set the user id of the signing key.
			//....................................
			SetDlgItemText(hDlg,IDC_SIGN_ID,(LPCTSTR)&CDLine1.ID);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if(hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Special hook for open file dialog for signing a file.
//......................................................
UINT CALLBACK MySignOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	LPHELPINFO		lphi;
	UINT			uCheck;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the send to file check box.
			//................................
			bSendToFile = TRUE;
			bTextOutput = FALSE;
			CheckDlgButton(hDlg,IDC_SIGTOFILE,BST_CHECKED);

			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_SIGTOFILE:
				{
					if (!bSendToFile)
					{
						bSendToFile = TRUE;
						CheckDlgButton(hDlg,IDC_SIGTOFILE,BST_CHECKED);
						CheckDlgButton(hDlg,IDC_SIGTOCLIP,BST_UNCHECKED);
						EnableWindow(GetDlgItem(hDlg,IDC_SIGTEXT),TRUE);
					}
				}
				break;

				case IDC_SIGTOCLIP:
				{
					if (bSendToFile)
					{
						bSendToFile = FALSE;
						CheckDlgButton(hDlg,IDC_SIGTOCLIP,BST_CHECKED);
						CheckDlgButton(hDlg,IDC_SIGTOFILE,BST_UNCHECKED);
						EnableWindow(GetDlgItem(hDlg,IDC_SIGTEXT),FALSE);
					}
				}
				break;

				case IDC_SIGTEXT:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_SIGTEXT);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bTextOutput = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bTextOutput = TRUE;
					}
					CheckDlgButton(hDlg,IDC_SIGTEXT,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_SIGTOFILE || lphi->iCtrlId == IDC_SIGTOCLIP ||
					lphi->iCtrlId == IDC_SIGTEXT)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

